#!/bin/bash
# SYSTEM-IS Kiosk UPDATER

FILE=/var/tmp/dispenser-update.tar.gz
SCRIPT=/var/tmp/dispenser-update.sh

# Compatibility for /var/tmp
#[ -d /var/tmp/att ] && {
#    mkdir -p /var/tmp/att
#    cp -uprdv /var/tmp/att/* /var/tmp/stl/
#    rm -rf /var/tmp/att
#}

set -e

echo "Checking updates" 

if [ -f "${FILE:?}" ]; then
    echo "Aplying updates ..." 

    tar -xvzf "${FILE:?}" -C / || {
        retval="$?" 
        echo "Some errors happened!" >&2
        rm -f "${FILE:?}" 
        exit "$retval" 
    }
    rm -f "${FILE:?}" 

    if [ -f "${SCRIPT:?}" ]; then
        echo "Running script ..." 
        "${SCRIPT:?}" || {
            retval="$?" 
            echo "Some errors happened!" >&2
            rm -f "${SCRIPT:?}" 
            exit "$retval" 
        }
    mv -vf "${SCRIPT:?}" "${SCRIPT:?}.done_$(date +%Y%m%d-%H%M%S)" 
    fi

    echo "Updating done" 
    echo

    echo "Running ldconfig" 
    /sbin/ldconfig
fi

echo "ALL DONE" 

sleep 5
echo "Starting Catering Dispenser..."
/opt/catdispenser/catdispenser.AppImage
